
-- 

USE BD_Air_France;

IF OBJECT_ID ('dbo.T_trajets_trj','U') IS NOT NULL
    DROP TABLE dbo.T_trajets_trj;
GO

CREATE TABLE T_trajets_trj
(trj_id HierarchyID NOT NULL, trj_aeroport VARCHAR(20), trj_temps_vol DECIMAL(5,2));
GO

-- Insertion d'lments dans la hirarchie

INSERT INTO T_trajets_trj(trj_id, trj_aeroport, trj_temps_vol)             
VALUES (HierarchyID::GetRoot(), 'Paris', 0);        

DECLARE @racine    HierarchyID;        
DECLARE @valence   HierarchyID;
DECLARE @blagnac   HierarchyID;
DECLARE @lyon      HierarchyID;
DECLARE @grenoble  HierarchyID;
DECLARE @marseille HierarchyID;
DECLARE @frejus    HierarchyID;
DECLARE @nimes     HierarchyID;

SELECT  @racine = HierarchyID::GetRoot() FROM T_trajets_trj;

INSERT INTO T_trajets_trj       (trj_id, trj_aeroport, trj_temps_vol)  
VALUES (@racine.GetDescendant(NULL,NULL), 'Blagnac', 1); 

SELECT  @blagnac = trj_id FROM T_trajets_trj WHERE trj_aeroport='Blagnac';          
INSERT INTO T_trajets_trj       (trj_id, trj_aeroport, trj_temps_vol)  
VALUES (@racine.GetDescendant(@blagnac,NULL), 'Lyon', 0.8); 

SELECT  @lyon = trj_id FROM T_trajets_trj WHERE trj_aeroport='Lyon';
INSERT INTO T_trajets_trj       (trj_id, trj_aeroport, trj_temps_vol)  
VALUES (@racine.GetDescendant(@lyon,NULL), 'Marseille', 0.9); 

-- fils 2eme niveau

INSERT INTO T_trajets_trj       (trj_id, trj_aeroport, trj_temps_vol)  
VALUES (@blagnac.GetDescendant(NULL,NULL), 'Pau', 0.4);

INSERT INTO T_trajets_trj       (trj_id, trj_aeroport, trj_temps_vol) 
VALUES (@lyon.GetDescendant(NULL,NULL), 'Grenoble', 0.3); 


SELECT  @grenoble = trj_id FROM T_trajets_trj WHERE trj_aeroport='Grenoble';
INSERT INTO T_trajets_trj       (trj_id, trj_aeroport, trj_temps_vol)
VALUES (@lyon.GetDescendant(@grenoble,NULL), 'Valence', 0.2);

SELECT  @marseille = trj_id FROM T_trajets_trj WHERE trj_aeroport='Marseille';
INSERT INTO T_trajets_trj       (trj_id, trj_aeroport, trj_temps_vol) 
VALUES (@marseille.GetDescendant(NULL,NULL), 'Frejus', 0.2); 

SELECT  @frejus = trj_id FROM T_trajets_trj WHERE trj_aeroport='Frejus';
INSERT INTO T_trajets_trj       (trj_id, trj_aeroport, trj_temps_vol)
VALUES (@marseille.GetDescendant(@frejus,NULL), 'Nimes', 0.35); 

-- entre 2

SELECT  @nimes = trj_id FROM T_trajets_trj WHERE trj_aeroport='Nimes';
INSERT INTO T_trajets_trj       (trj_id, trj_aeroport, trj_temps_vol)
VALUES (@marseille.GetDescendant(@frejus,@nimes), 'Toulon', 0.15);

-- 3eme niveau

INSERT INTO T_trajets_trj (trj_id, trj_aeroport, trj_temps_vol)
VALUES (@grenoble.GetDescendant(NULL,NULL), 'Gap', 0.35); 

SELECT  @valence = trj_id FROM T_trajets_trj WHERE trj_aeroport='Valence';
INSERT INTO T_trajets_trj(trj_id, trj_aeroport, trj_temps_vol)
VALUES (@valence .GetDescendant(NULL,NULL), 'Ales', 0.25);


-- 199, Visualisation

SELECT CAST(trj_id AS VARBINARY(8)) AS "noeud", 
       CAST(trj_id.GetAncestor(1) AS VARBINARY(8)) AS "parent", 
       trj_aeroport, trj_temps_vol 
FROM T_trajets_trj
ORDER BY 1;

-- ordre par caractres diffrent de l'ordre de l'arbre

SELECT CAST(trj_id.ToString() AS VARcHAR(8)) AS " HierarchyID", 
       trj_aeroport, trj_temps_vol 
FROM T_trajets_trj
ORDER BY 1;

SELECT CAST(trj_id AS VARCHAR(8)) AS "noeud", 
       trj_id.GetLevel() AS "GetLevel()", 
       CAST(CONCAT(SPACE(4*trj_id.GetLevel()),trj_aeroport) AS VARcHAR(30)) AS "aroport", 
     trj_temps_vol 
FROM T_trajets_trj
ORDER BY trj_id;

-- 200, modif arbre

DECLARE @nimes     HierarchyID;
DECLARE @valence   HierarchyID;
DECLARE @marseille HierarchyID;
SELECT  @marseille = trj_id FROM T_trajets_trj WHERE trj_aeroport='Marseille';
SELECT  @nimes     = trj_id FROM T_trajets_trj WHERE trj_aeroport='Nimes';
SELECT  @valence   = trj_id FROM T_trajets_trj WHERE trj_aeroport='Valence';

UPDATE T_trajets_trj 
SET    trj_id       = @nimes.GetReparentedValue(@marseille, @valence) 
WHERE  trj_aeroport = 'Nimes';

SELECT trj_id, trj_id.GetLevel() AS "GetLevel()", 
CONCAT(SPACE(4*trj_id.GetLevel()),trj_aeroport) AS "aroport", trj_temps_vol 
FROM T_trajets_trj
ORDER BY 1;

--Parcours

DECLARE @marseille HierarchyID;
SELECT  @marseille = trj_id FROM T_trajets_trj WHERE trj_aeroport='Marseille';

SELECT
 CAST(CONCAT(SPACE(4*trj_id.GetLevel()),trj_aeroport) AS VARcHAR(30)) AS "aroport", trj_temps_vol 
FROM T_trajets_trj
WHERE trj_id.IsDescendantOf(@marseille)=1
ORDER BY trj_id;

-- CTE

WITH Q_arborescence(id, chemin, duree)
   AS 
  (SELECT     trj_id.GetAncestor(1), CAST(trj_aeroport AS VARCHAR(max)), trj_temps_vol
   FROM   T_trajets_trj
   WHERE  trj_aeroport = 'Nimes'
 UNION ALL
   SELECT tj.trj_id.GetAncestor(1), chemin+'/' +tj.trj_aeroport,
          CAST(a.duree+tj.trj_temps_vol AS DECIMAL(5,2))
   FROM   T_trajets_trj tj
   JOIN   Q_arborescence a ON a.id = tj.trj_id)
SELECT chemin, duree
FROM   Q_arborescence
WHERE  id IS NULL;


-- 201, contraintes et indexation

ALTER TABLE T_trajets_trj
ADD CONSTRAINT pk_trajets_trj PRIMARY KEY(trj_id);

ALTER TABLE T_trajets_trj
ADD niveau As trj_id.GetLevel();

CREATE INDEX IX_largeur_d_abord
ON T_trajets_trj(niveau,trj_id);

ALTER TABLE T_trajets_trj
      ADD trj_parent_id AS trj_id.GetAncestor(1) PERSISTED
      REFERENCES T_trajets_trj(trj_id);

DROP TABLE T_trajets_trj;
GO